require 'g_level'
g_level.reset()

--params
island_show_time = 75  --75
perfect_garden_show_time = 45 --45
dark_garden_show_time = 50  --50
fade_time = 2


--SET 1 the island
if parameter == 0 then

    --INIT TEXTURES  init all textures here.
    h = FM_NEAREST;
    lua_init_texture("island", "data/images/cutscene/saari.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
    lua_init_texture("fade", "data/images/effects/black.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
    lua_init_texture("perfect_garden", "data/images/cutscene/park-day.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
    lua_init_texture("dark_garden", "data/images/cutscene/park-fall.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
    lua_init_texture("book", "data/images/cutscene/kirja.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
    --lua_init_texture("butler_scene_background", "data/images/cutscene/park-fall-butler.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
    lua_init_texture("butler", "data/images/characters/butler.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
    --lua_init_texture("sign", "data/images/lvl_forest/sign2.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
    --lua:do_file("data/scripts/crt_player.lua",0) --load player in the beginning also...

    -- Create Level
    g_level.reset()
    lua:create_level(1.0,1.0,1.0,1.0)   --RGBA values are given also
    lua:create_layer(0.0,0.0,BM_DEFAULT)  -- x_scroll , y_scroll, blendmode  -- 0
    lua:create_layer(1.0,1.0,BM_DEFAULT) -- 1 --physics layer
    lua:create_layer(1.0,1.0,BM_DEFAULT) -- 2
    lua:create_layer(0.0,0.0,BM_DEFAULT) -- 3 --dummy

    -- Island
    local scale = 0.8
    lua:create_sprite("island", ST_TEXTURED,"island",               0.0, 0.0) 
    lua:sprite_shape("island",ST_TEXTURED,                          scale * 2340.0/2, scale * 1170.0/2)
    lua:textured_sprite_tex_coords("island", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
    lua:remorfable_sprite("remo1", "island", time_to_remo_speed(island_show_time), false)             -- name, sprite_name, speed, repeat
    
    lua:add_key_frame(1.0, -800.0, 400.0, 0.0, 2.5)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(1.0,1.0,1.0,1.0)  -- r,g,b,a
    lua:upload_key_frame("remo1")

    g_level.upload("remo1", 0)
    
    --text
    local x = 0.0
    local y = 150.0
    lua:create_text("tuomo","comic_sans",x,y,0.2,0.6) --name, font, x,y, delay, scale
    lua:text_color("tuomo",1.0,1.0,1.0,1.0)  --name, r,g,b,a
    lua:add_text("tuomo", "In every story,")
    lua:add_text("tuomo", "there is a magical place where it all begins and ends.")
    lua:add_text("tuomo", "It's beatiful place, filled with ordinary people.")
    lua:add_text("tuomo", "Well, this place ain't it.")
    lua:add_text("tuomo", "Magical and uncommon sure, but you see, ")
    lua:add_text("tuomo", "this is the place where the not-so-ordinary live.")
    lua:add_text("tuomo", "When a proper zombie turn into a communist,")
    lua:add_text("tuomo", "or a unicorn to gay. They are all sent here...")
    lua:add_text("tuomo", "But let's start our story.")
    lua:remorfable_sprite("remo", "tuomo", time_to_remo_speed(island_show_time-fade_time), false)             -- name, sprite_name, speed, repeat

    lua:add_key_frame(0.9, x, y, 0.0, 0.7)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(1.0,1.0,1.0,1.0)  -- r,g,b,a
    lua:upload_key_frame("remo")
    lua:add_key_frame(1.0, x, y, 0.0, 0.7)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(1.0,1.0,1.0,0.0)  -- r,g,b,a
    lua:upload_key_frame("remo")

    g_level.upload("remo",1)
    lua:gameobject_remove_from_temp_list( "tuomo" )
    --text
    
    --text
    local x = 0.0
    local y = -300.0
    local color = 0.0
    lua:create_text("tuomo","comic_sans",x,y,0.0,0.7) --name, font, x,y, delay, scale
    lua:text_color("tuomo",color,color,color,0.0)  --name, r,g,b,a
    lua:add_text("tuomo", "PRESS SPACE to skip")
    lua:remorfable_sprite("remo", "tuomo", time_to_remo_speed(7), false)-- name, sprite_name, speed, repeat
    lua:add_key_frame(0.2, x, y, 0.0, 0.7)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(color,color,color,0.7)  -- r,g,b,a
    lua:upload_key_frame("remo")
    lua:add_key_frame(0.8, x, y, 0.0, 0.7)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(color,color,color,0.7)  -- r,g,b,a
    lua:upload_key_frame("remo")
    lua:add_key_frame(1.0, x, y, 0.0, 0.7)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(color,color,color,0.0)  -- r,g,b,a
    lua:upload_key_frame("remo")

    g_level.upload("remo",2)
    lua:gameobject_remove_from_temp_list( "tuomo" )
    --text
    
    
    
    fade_in(fade_time) --time

    timer_adv(island_show_time,"data/scripts/lvl_intro.lua",false, 11) -- time, script, is_repeat, id
    --lua:set_game_state(GS_FREEZE) -- sets the game state to menu. thus you are able to use the menu commands
    
    lua:do_file("data/scripts/inc_skip_button.lua")
    g_level.next_level = "data/scripts/lvl_mothers_office.lua"
    
elseif parameter == 11 then    
    if lua:get_game_state() ~= GS_PLAY then
        timer_adv(1.99,"data/scripts/lvl_intro.lua",false, 1) -- time, script, is_repeat, id
        fade_out(fade_time)
    end
------------------------------------------------------------------------
-- SET 2 the perfect garden
elseif parameter == 1 then
    -- Create Level
    g_level.reset()
    lua:create_level(1.0,1.0,1.0,1.0)   --RGBA values are given also
    lua:create_layer(0.0,0.0,BM_DEFAULT)  -- x_scroll , y_scroll, blendmode  -- 0
    lua:create_layer(1.0,1.0,BM_DEFAULT) -- 1 --physics layer
    lua:create_layer(1.0,1.0,BM_DEFAULT) -- 2
    lua:create_layer(0.0,0.0,BM_DEFAULT) -- 3 --dummy
    
    --perfect garden
    local scale = 1.2
    lua:create_sprite("perfect_garden", ST_TEXTURED,"perfect_garden",            0.0, 0.0) 
    lua:sprite_shape("perfect_garden",ST_TEXTURED,                               scale * 2048.0/2, scale * 1024.0/2)
    lua:textured_sprite_tex_coords("perfect_garden", ST_TEXTURED,                0.0, 0.0, 1.0, 1.0)    
    lua:remorfable_sprite("remo2", "perfect_garden", time_to_remo_speed(perfect_garden_show_time), false)             -- name, sprite_name, speed, repeat
    
    lua:add_key_frame(1.0, 0.0, 0.0, 0.0, 0.8)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(1.0,1.0,1.0,1.0)  -- r,g,b,a
    lua:upload_key_frame("remo2")

    g_level.upload("remo2",0)
    --perfection end
    
    --text
    local x = 0.0
    local y = 150.0
    lua:create_text("tuomo","comic_sans",x,y,0.2,0.7) --name, font, x,y, delay, scale
    lua:text_color("tuomo",1.0,1.0,1.0,1.0)  --name, r,g,b,a
    lua:add_text("tuomo", "Once upon a time")
    lua:add_text("tuomo", "there was a man and a woman.")
    lua:add_text("tuomo", "They lived in a big mansion,")
    lua:add_text("tuomo", "with man's mother and a house butler.")
    lua:add_text("tuomo", "You could say their life was pretty much perfect.")
    lua:add_text("tuomo", "But...")
    lua:remorfable_sprite("remo", "tuomo", time_to_remo_speed(perfect_garden_show_time-fade_time), false)             -- name, sprite_name, speed, repeat

    lua:add_key_frame(0.9, x, y, 0.0, 0.7)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(1.0,1.0,1.0,1.0)  -- r,g,b,a
    lua:upload_key_frame("remo")
    
    lua:add_key_frame(1.0, x, y, 0.0, 0.7)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(1.0,1.0,1.0,0.0)  -- r,g,b,a
    lua:upload_key_frame("remo")

    g_level.upload("remo",1)
    lua:gameobject_remove_from_temp_list( "tuomo" )
    --text
    
    fade_in(fade_time)

    timer_adv(perfect_garden_show_time,"data/scripts/lvl_intro.lua",false,12) -- time, script,is_repeat, id
    --lua:set_game_state(GS_FREEZE) -- sets the game state to menu. thus you are able to use the menu commands

    lua:do_file("data/scripts/inc_skip_button.lua")
    g_level.next_level = "data/scripts/lvl_mothers_office.lua"      
      
elseif parameter == 12 then    
    if lua:get_game_state() ~= GS_PLAY then
        timer_adv(1.99,"data/scripts/lvl_intro.lua",false, 2) -- time, script, is_repeat, id
        fade_out(fade_time)
    end
-------------------------------------------------------------------------
-- SET 3 the dark garden
elseif parameter == 2 then
    -- Create Level
    g_level.reset()
    lua:create_level(1.0,1.0,1.0,1.0)   --RGBA values are given also
    lua:create_layer(0.0,0.0,BM_DEFAULT)  -- x_scroll , y_scroll, blendmode  -- 0
    lua:create_layer(1.0,1.0,BM_DEFAULT) -- 1 --physics layer
    lua:create_layer(1.0,1.0,BM_DEFAULT) -- 2
    lua:create_layer(0.0,0.0,BM_DEFAULT) -- 3 --dummy

    --dark garden
    local scale = 0.85
    lua:create_sprite("dark_garden", ST_TEXTURED,"dark_garden",               0.0, 0.0) 
    lua:sprite_shape("dark_garden",ST_TEXTURED,                               scale * 2048.0/2, scale * 1024.0/2)
    lua:textured_sprite_tex_coords("dark_garden", ST_TEXTURED,                0.0, 0.0, 1.0, 1.0)  
    --lua:remorfable_sprite("remo3", "dark_garden", time_to_remo_speed(dark_garden_show_time), false)             -- name, sprite_name, speed, repeat
    
    --lua:add_key_frame(1.0, 0.0, 0.0, 0.0, 1.0)  -- adds a new key frame. time, x, y, rotation, scale
    --lua:add_key_frame_color(1.0,1.0,1.0,1.0)  -- r,g,b,a
    --lua:upload_key_frame("remo3")

    g_level.upload("dark_garden",0)
    -- dark garden
    
    --text
    local x = 0.0
    local y = 150.0
    lua:create_text("tuomo","comic_sans",x,y,0.2,0.7) --name, font, x,y, delay, scale
    lua:text_color("tuomo",1.0,1.0,1.0,1.0)  --name, r,g,b,a
    lua:add_text("tuomo", "Not every fairy tale goes by the book.. Not even this.")
    lua:add_text("tuomo", "If you are a vampire, you might note")
    lua:add_text("tuomo", "that you can't always control yourself")
    lua:add_text("tuomo", "when it comes about blood...")
    lua:add_text("tuomo", "and expecially about sucking it.")
    lua:remorfable_sprite("remo", "tuomo", time_to_remo_speed(dark_garden_show_time-fade_time), false)             -- name, sprite_name, speed, repeat

    lua:add_key_frame(0.9, x, y, 0.0, 0.7)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(1.0,1.0,1.0,1.0)  -- r,g,b,a
    lua:upload_key_frame("remo")
    lua:add_key_frame(1.0, x, y, 0.0, 0.7)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(1.0,1.0,1.0,0.0)  -- r,g,b,a
    lua:upload_key_frame("remo")

    g_level.upload("remo",2)
    lua:gameobject_remove_from_temp_list( "tuomo" )
    --text
    
    --the book
    local scale = 1.0
    local xb = 0.0
    local yb = 100.0
    local book_anim_speed = time_to_remo_speed(dark_garden_show_time)
    lua:create_sprite("dark_garden", ST_TEXTURED,"book",               xb, yb) 
    lua:sprite_shape("dark_garden",ST_TEXTURED,                               scale * 256.0/2, scale * 256.0/2)
    lua:textured_sprite_tex_coords("dark_garden", ST_TEXTURED,                0.0, 0.0, 1.0, 1.0)
    lua:sprite_color("dark_garden",1.0,1.0,1.0,0.0)                           --name,r,g,b,a
    lua:remorfable_sprite("remorfable", "dark_garden", book_anim_speed, false) -- name, sprite_name, speed, repeat
    --appear    
    lua:add_key_frame(0.2, xb, yb, 0.0, 1.0)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(1.0,1.0,1.0,1.0)  -- r,g,b,a
    lua:upload_key_frame("remorfable")
    --stay
    lua:add_key_frame(0.5, xb, yb, 0.0, 1.0)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(1.0,1.0,1.0,1.0)  -- r,g,b,a
    lua:upload_key_frame("remorfable")
    --disappear
    lua:add_key_frame(0.7, xb, yb, 0.0, 1.0)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(1.0,1.0,1.0,0.0)  -- r,g,b,a
    lua:upload_key_frame("remorfable")    
    g_level.upload("remorfable",1)

    fade_in(fade_time)

    timer_adv(dark_garden_show_time,"data/scripts/lvl_intro.lua",false,13) -- time, script, is_repeat, id
    --lua:set_game_state(GS_FREEZE) -- sets the game state to menu. thus you are able to use the menu commands
    
    lua:do_file("data/scripts/inc_skip_button.lua")
    g_level.next_level = "data/scripts/lvl_mothers_office.lua"
    
elseif parameter == 13 then    --butler dialog...    
    if lua:get_game_state() ~= GS_PLAY then
        local scale = 0.5
        xb = 400.0
        yb = -200.0
        lua:create_sprite("butler", ST_TEXTURED,"butler",               xb, yb) 
        lua:sprite_shape("butler",ST_TEXTURED,                          128.0*scale, 512.0*scale)
        lua:textured_sprite_tex_coords("butler", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
        lua:sprite_color("butler",1.0,1.0,1.0,0.0)
        lua:remorfable_sprite("remorfable", "butler", time_to_remo_speed(2), false) -- name, sprite_name, speed, repeat
        --disappear
        lua:add_key_frame(1.0, xb, yb, 0.0, 1.0)  -- adds a new key frame. time, x, y, rotation, scale
        lua:add_key_frame_color(1.0,1.0,1.0,1.0)  -- r,g,b,a
        lua:upload_key_frame("remorfable")    
        g_level.upload("remorfable",1)
        timer_adv(2,"data/scripts/lvl_intro.lua",false,23)
    end
    
elseif parameter == 23 then --butler fade in to stay...
    --butler
    local scale = 0.5
    lua:create_sprite("butler", ST_TEXTURED,"butler",               400.0, -200.0) 
    lua:sprite_shape("butler",ST_TEXTURED,                          128.0*scale, 512.0*scale)
    lua:textured_sprite_tex_coords("butler", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
    g_level.upload("butler",                                        1)

    --text
    local x = 0.0
    local y = -300.0
    local color = 0.0
    lua:create_text("tuomo","comic_sans",x,y,0.0,0.7) --name, font, x,y, delay, scale
    lua:text_color("tuomo",color,color,color,0.0)  --name, r,g,b,a
    lua:add_text("tuomo", "PRESS SPACE to continue")
    lua:remorfable_sprite("remo", "tuomo", time_to_remo_speed(7), false)-- name, sprite_name, speed, repeat
    lua:add_key_frame(0.2, x, y, 0.0, 0.7)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(color,color,color,0.7)  -- r,g,b,a
    lua:upload_key_frame("remo")
    lua:add_key_frame(0.8, x, y, 0.0, 0.7)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(color,color,color,0.7)  -- r,g,b,a
    lua:upload_key_frame("remo")
    lua:add_key_frame(1.0, x, y, 0.0, 0.7)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(color,color,color,0.0)  -- r,g,b,a
    lua:upload_key_frame("remo")

    g_level.upload("remo",2)
    lua:gameobject_remove_from_temp_list( "tuomo" )
    --text


    --start dialog
    lua:do_file("data/scripts/dialogs/dia_butler_park.lua")
    
    timer_adv(7,"data/scripts/lvl_intro.lua",false,333)
    g_level.next_level = "data/scripts/lvl_mothers_office.lua"
    
-------------------------------------------------------------------------
-- SET 4 the butler scene (playable)
elseif parameter == 333 then

    if lua:get_game_state() == GS_PLAY then
        g_level.next_level = "data/scripts/lvl_mothers_office.lua"
        lua:do_file("data/scripts/srt_next_level.lua")
   else    
        timer_adv(2,"data/scripts/lvl_intro.lua",false,333)
    end
end

